"""
<problem>
Problem Link: https://leetcode.com/problems/n-ary-tree-level-order-traversal/

Given an n-ary tree, return the level order traversal of its nodes' values.
Nary-Tree input serialization is represented in their level order traversal, 
each group of children is separated by the null value. 

Example 1:
Input: root = [1,null,3,2,4,null,5,6]
Output: [[1],[3,2,4],[5,6]]

Example 2:
Input: root = [1,null,2,3,4,5,null,null,6,7,null,8,null,9,10,null,null,11,null,12,null,13,null,null,14]
Output: [[1],[2,3,4,5],[6,7,8,9,10],[11,12,13],[14]]
 
Constraints:
The height of the n-ary tree is less than or equal to 1000
The total number of nodes is between [0, 10^4]
"""
"""
# Definition for a Node.
class Node:
    def __init__(self, val=None, children=None):
        self.val = val
        self.children = children
</problem>
<bug_fixes>
Replace `None` with `[]` on line 5.
Replace `root` with `[root]` on line 7.
Replace `cur_level_val` with `next_level` on line 15.
</bug_fixes>
<bug_desc>
On line 5, if there is no root node, None is returned. This is incorrect behavior as an invalid return value will pass up in the recursion stack. To fix this, simply return res or [].
On line 7, queue is set to root. The queue variable is now a single Node object instead of a list of nodes. This will cause an issue because the while loop expects queue to be an iterable (like a list) so that it can iterate over its elements.
On line 15, the child node of cur_node is added to the list cur_level_val. This is incorrect because the code is no longer separating the values of the current level from the values of the next level. Instead, it is adding the child nodes of the current level to the same list cur_level_val, which is supposed to contain only the values of the current level.
</bug_desc>
"""
class Solution:
    def levelOrder(self, root: 'Node') -> List[List[int]]:
        res = []
        if not root:
          return None
        
        queue = root
        while queue:
          next_level = []
          cur_level_val = []
          
          for cur_node in queue:
            cur_level_val.append(cur_node.val)
            if cur_node.children:
              cur_level_val.extend(cur_node.children)
              
          queue = next_level
          res.append(cur_level_val)
        return res
